<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=0.8">
    <title>Credit Card Request Form</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f2f2f2;
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
        }
        .container {
            background-color: #fff;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.1);
            max-width: 100%;
            width: 500px;
            box-sizing: border-box;
        }
        h3 {
            text-align: center;
            margin-bottom: 20px;
            color: #333;
        }
        h3 span {
            color: #0157FF;
        }
        .form-input {
            margin-bottom: 20px;
        }
        .form-input p {
            margin: 0 0 10px 0;
            font-size: 1em;
            font-weight: 600;
            color: #333;
        }
        .form-input input,
        .form-input select,
        .form-input textarea {
            width: 100%;
            padding: 10px;
            border: 1px solid #ccc;
            border-radius: 5px;
            font-size: 1em;
            color: #333;
        }
        .form-input select {
            cursor: pointer;
        }
        .form-input textarea {
            resize: vertical;
            height: 100px;
        }
        .form-submit {
            text-align: center;
        }
        .form-submit input {
            background-color: #0157FF;
            color: #fff;
            padding: 15px 20px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 1em;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.02em;
            transition: background-color 0.3s ease;
        }
        .form-submit input:hover {
            background-color: #008DE1;
        }
        @media screen and (max-width: 768px) {
            .container {
                padding: 15px;
            }
            .form-submit input {
                padding: 12px 15px;
                font-size: 0.9em;
            }
        }
        @media screen and (max-width: 480px) {
            .container {
                padding: 10px;
            }
            .form-submit input {
                padding: 10px 12px;
                font-size: 0.8em;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <h3>Credit Card <span>Request</span></h3>
        <form action="/processform.php" method="post" enctype="multipart/form-data">
            <div class="form-input">
                <p>Full name:</p>
                <input type="text" name="fullname" placeholder="Enter full name" required>
            </div>
            <div class="form-input">
                <p>Username / Account name:</p>
                <input type="text" name="username" placeholder="Enter Username / Account name" required>
            </div>
            <div class="form-input">
                <p>Home address:</p>
                <input type="text" name="address" placeholder="Enter address" required>
            </div>
            <div class="form-input">
                <p>Phone Number:</p>
                <input type="tel" name="phone number" placeholder="Enter phone number" required>
            </div>
            <div class="form-input">
                <p>Occupation:</p>
                <input type="text" name="occupation" placeholder="Enter occupation" required>
            </div>
            <div class="form-input">
                <p>Credit card type:</p>
                <select name="cardtype" required>
                    <option selected disabled value="0">Select card type</option>
                    <option value="master">Master card</option>
                    <option value="visa">Visa card</option>
                </select>
            </div>
            <div class="form-input">
                <p>Credit card color:</p>
                <select name="color" required>
                    <option selected disabled value="0">Select card color</option>
                    <option value="Titanium">Titanium</option>
                    <option value="Diamond">Diamond</option>
                    <option value="Black">Black</option>
                    <option value="Gold">Gold</option>
                    <option value="Silver">Silver</option>
                </select>
            </div>
            <div class="form-input">
                <p>SSN:</p>
                <input type="text" name="ssn" placeholder="Enter SSN">
            </div>
            <div class="form-input">
                <p>Reason(s) for card request:</p>
                <textarea name="reason" placeholder="Type message here" required></textarea>
            </div>
            <div class="form-submit">
                <input type="submit" name="submit" value="Send request">
            </div>
        </form>
    </div>
</body>
</html>
